﻿<%@ Page Title="Cohort Criteria" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Cohort.aspx.cs" Inherits="VIRP_WEB.Cohorts.Cohort" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:Label ID="lblPageTitle" runat="server" Text="Cohort Criteria" Font-Size="X-Large" />
    <br /><br />
    <asp:Label ID="lblResult" runat="server" ForeColor="Red" />

    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>

            <asp:Label ID="lblDobMin" runat="server" Text="DOB Min" AssociatedControlID="txtDobMin" />&nbsp;
            <asp:TextBox ID="txtDobMin" runat="server" ToolTip="Enter a minimum Date of Birth value for Cohort criteria" MaxLength="10" onkeypress="return CheckDate(event);" />
            <ajax:CalendarExtender runat="server" ID="calDobMin" Animated="false" TargetControlID="txtDobMin" />&nbsp;
            <asp:Label ID="lblDobMax" runat="server" Text="DOB Max" AssociatedControlID="txtDobMax" />&nbsp;
            <asp:TextBox ID="txtDobMax" runat="server" ToolTip="Enter a maximum Date of Birth value for Cohort criteria" MaxLength="10" onkeypress="return CheckDate(event);" />
            <ajax:CalendarExtender runat="server" ID="calDobMax" Animated="false" TargetControlID="txtDobMax" />
            &nbsp;
            
            <ajax:TextBoxWatermarkExtender ID="wmDobMin" runat="server" TargetControlID="txtDobMin" WatermarkCssClass="watermark" />
            <ajax:TextBoxWatermarkExtender ID="wmDobMax" runat="server" TargetControlID="txtDobMax" WatermarkCssClass="watermark" />
            
            <br /><br />

            <asp:Table ID="tblCategories" runat="server">
                <asp:TableRow>
                    <asp:TableCell HorizontalAlign="Center">Available Categories</asp:TableCell>
                    <asp:TableCell HorizontalAlign="Center">&nbsp;</asp:TableCell>
                    <asp:TableCell HorizontalAlign="Center">Selected Categories</asp:TableCell>
                </asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell>
                        <asp:ListBox ID="listSource" runat="server" Width="200px" Rows="10" SelectionMode="Multiple" />
                    </asp:TableCell>
                    <asp:TableCell HorizontalAlign="Center" VerticalAlign="Middle" Width="200px">
                        <asp:Button ID="btnAddAll" runat="server" Text="Add All ►►" ToolTip="Add all available categories to the selected categories list" Width="150" OnClick="BtnAddAll_Click" /><br /><br />
                        <asp:Button ID="btnAddOne" runat="server" Text="Add Selected ►" ToolTip="Add only the selected categories to the selected list " Width="150" OnClick="BtnAddOne_Click" /><br /><br />
                        <asp:Button ID="btnRemOne" runat="server" Text="Remove Selected ◄" ToolTip="Remove only the selected categories from the selected list" Width="150" OnClick="BtnRemOne_Click" /><br /><br />
                        <asp:Button ID="btnRemAll" runat="server" Text="Remove All ◄◄" ToolTip="Remove all selected categories from the selected categories list" Width="150" OnClick="BtnRemAll_Click" />
                    </asp:TableCell>
                    <asp:TableCell>
                        <asp:ListBox ID="listDestination" runat="server" Width="200px" Rows="10" SelectionMode="Multiple" OnSelectedIndexChanged="ListDestination_SelectedIndexChanged" AutoPostBack="true" />
                    </asp:TableCell>
                </asp:TableRow>
            </asp:Table>

            <br /><br />

            <asp:Label ID="lblCategories" runat="server" Font-Bold="true" Font-Underline="true" />
            <br />
            <asp:CheckBox ID="chkAll" runat="server" Text="Toggle All" ToolTip="Select to toggle all check boxes" AutoPostBack="true" OnCheckedChanged="ChkAll_CheckedChanged" />
            <br />
            <asp:CheckBoxList ID="listCategories" runat="server" OnSelectedIndexChanged="ListCategories_SelectedIndexChanged" AutoPostBack="true" />
        </ContentTemplate>
    </asp:UpdatePanel>
    
    <asp:UpdateProgress ID="UpdateProgress1" AssociatedUpdatePanelID="UpdatePanel1" runat="server" DisplayAfter="0"> 
    <ProgressTemplate> 
       <div id="modalDiv" class="delayModalStyle" style="position:fixed; height:100%; width: 100%; top:0; left:0; z-index: 100;"> 
        &nbsp; 
        </div>
        <div id="delayIndicatorDiv" class="delayIndicatorStyle" style="position:fixed; top:50%; left:40%; z-index:1003;"> 
            <img alt="" src="../Images/ajax-loader.gif" />
            Processing request. Please wait.
        </div> 
    </ProgressTemplate> 
    </asp:UpdateProgress>

    <br />

    <asp:Table ID="tblForm2" runat="server" style="width:100%; display:inline;">
        <asp:TableRow>
            <asp:TableCell Width="25%">
                <asp:Button ID="btnBack" runat="server" Text="Back" ToolTip="Select to save and go back" OnClick="BtnBack_Click" OnClientClick='return confirm("This will save your Cohort Criteria selections and may take several seconds to process.  Select OK to save selections or Cancel to stop.");' />
            </asp:TableCell>
            <asp:TableCell Width="50%" HorizontalAlign="Center">
                <asp:Button ID="btnPreview" runat="server" Text="Preview" OnClick="BtnPreview_Click" ToolTip="Select to preview cohort results based on selected criteria" style="display:none;" />
                &nbsp;&nbsp;
                <asp:Button ID="btnSave1" runat="server" Text="Save" OnClick="BtnSave_Click" ToolTip="Select to save selected cohort criteria" OnClientClick='return confirm("This will save your Cohort Criteria selections and may take several seconds to process.  Select OK to save selections or Cancel to stop.");' />
                &nbsp;&nbsp;
                <asp:Button ID="btnReset" runat="server" Text="Reset" OnClick="BtnReset_Click" ToolTip="Select to clear or undo changes made to Cohort criteria" />
            </asp:TableCell>
            <asp:TableCell Width="25%" HorizontalAlign="Right">
                <asp:Button ID="btnNext" runat="server" Text="Next" ToolTip="Select to save and continue" OnClick="BtnNext_Click" OnClientClick='return confirm("This will save your Cohort Criteria selections and may take several seconds to process.  Select OK to save selections or Cancel to stop.");' />
            </asp:TableCell>
        </asp:TableRow>
    </asp:Table>

    <br />

    <asp:Panel ID="pnlPreview" runat="server" CssClass="modalPopup" style="display:none;">
        <div class="modalPopupTitle">&nbsp;&nbsp;<asp:Label ID="lblCohortPreview" runat="server" Text="Preview" /></div>
        <br />
        <asp:Label ID="lblRecordCount" runat="server" />

        <br /><br />

        <asp:Table ID="tblForm" runat="server" style="width:100%;">
            <asp:TableRow>
                <asp:TableCell HorizontalAlign="Center">
                    <asp:Button ID="btnSave2" runat="server" Text="Save" OnClick="BtnSave_Click" ToolTip="Select to save selected cohort criteria" />
                    &nbsp;&nbsp;
                    <asp:Button ID="btnCancel" runat="server" Text="Close Preview" OnClick="BtnCancel_Click" ToolTip="Select to close preview and continue making changes to cohort criteria" />
                </asp:TableCell>
            </asp:TableRow>
        </asp:Table>
        <br /><br />
    </asp:Panel>

    <asp:Button ID="btnHide" runat="server" style="display:none;" />

    <ajax:ModalPopupExtender ID="mpePreview" runat="server" 
        BackgroundCssClass="modalBackground" CancelControlID="btnCancel" PopupControlID="pnlPreview" TargetControlID="btnHide"  />

</asp:Content>
